unit Config1C;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs;

type

  { TComponent1C }

  TConfiguration1C = class;
  TComponent1C = class(TComponent)
  private
    FConfiguration: TConfiguration1C;
    procedure SetConfiguration(const AValue: TConfiguration1C);
  protected
    //    - 
    //   /  OLE-
    //      !
    procedure ConnectEvent; virtual; abstract;
  public
  published
    //   
    property Configuration: TConfiguration1C read FConfiguration write SetConfiguration;
  end;

  { TConfiguration1C }

  TConfiguration1C = class(TComponent)
  private
    //  -      RT
    FAutoConnect: Boolean;
    //  -
    FClients: TList;
    //    1-
    FCommandLine: String;
    //   
    FServer: Variant;
    //  -  splash-     
    FShowSplash: Boolean;
    //  -    
    FConnected: Boolean;
    // 
    FAfterConnect: TNotifyEvent;
    FBeforeConnect: TNotifyEvent;
    // get-  set-
    function GetEvalExprValue(const AExpression: String): Variant;
  protected
    //      
    procedure SendConnectEvent;
    //    
    procedure InsertClient(AClient: TComponent1C);
    //   
    procedure RemoveClient(AClient: TComponent1C);
    //    properties
    procedure Loaded; override;
  public
    // 
    constructor Create(AOwner: TComponent); override;
    // 
    destructor Destroy; override;
    //    OLE-
    procedure DoConnect;
    //  -  
    property Connected: Boolean read FConnected;
    //  property,    
    //  1- "EvalExpr",   
    // "Configuration.Server.EvalExpr(''])"
    //   "Configuration['']"
    property EvalExpr[const Expression: String]: Variant
      read GetEvalExprValue; default;
    //   OLE-
    property Server: Variant read FServer;
    //   1-
    // (<>)
    function CreateObject(AObjectTypeName: String): Variant;
    // ExecuteBatch(<>)
    function ExecuteBatch(AOperatorsStr: String): Boolean;
  published
    //  -    
    property AutoConnect: Boolean read FAutoConnect write FAutoConnect;
    //    
    property CommandLine: String read FCommandLine write FCommandLine;
    //  -  "splash-"
    property ShowSplash: Boolean read FShowSplash write FShowSplash;
    //  
    property AfterConnect: TNotifyEvent read FAfterConnect write FAfterConnect;
    property BeforeConnect: TNotifyEvent read FBeforeConnect write FBeforeConnect;
  end;

procedure Register;

implementation

uses
  ComObj;

const
  OLE_True = -1;
  OLE_False = 0;

procedure Register;
begin
  RegisterComponents('1C Servers', [TConfiguration1C]);
end;

{ TComponent1C }

procedure TComponent1C.SetConfiguration(const AValue: TConfiguration1C);
begin
  if FConfiguration <> AValue then begin
    //       
    if Assigned(FConfiguration) then
      FConfiguration.RemoveClient(Self);
    //   
    FConfiguration := AValue;
    //       
    if Assigned(FConfiguration) then
      FConfiguration.InsertClient(Self);
  end;
end;

{ TConfiguration1C }

// 
constructor TConfiguration1C.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  //  properties
  FAutoConnect := False;
  FServer := Unassigned;
  FConnected := False;
  FCommandLine := '/M';  // 
  FShowSplash := False;
  //  
  FClients := TList.Create;
end;

// 
destructor TConfiguration1C.Destroy;
begin
  //  
  FClients.Free;
  inherited;
end;

//    OLE-
procedure TConfiguration1C.DoConnect;
var
  SplashStr: String;
begin
  //    ,   
  if FConnected then begin
    Exit;
  end;
  //   
  FConnected := False;
  try
    //  " "
    if Assigned(BeforeConnect) then BeforeConnect(Self);
    //  -   1
    if ShowSplash then
      SplashStr := ''
    else
      SplashStr := 'NO_SPLASH_SHOW';
    // 
    FServer := CreateOleObject('V77.Application');
    if Server.Initialize(Server.RMTrade, CommandLine, SplashStr) = OLE_False then begin
      //   
      ShowMessage('   1:!');
      Exit;
    end;
    FConnected := True;
    //   ""  
    SendConnectEvent;
    //  " "
    if Assigned(AfterConnect) then AfterConnect(Self);
  except
    //   
    ShowMessage('   1:!');
  end;
end;

//    
procedure TConfiguration1C.InsertClient(AClient: TComponent1C);
begin
  FClients.Add(AClient);
end;

//   
procedure TConfiguration1C.RemoveClient(AClient: TComponent1C);
begin
  FClients.Extract(AClient);
end;

//    properties
procedure TConfiguration1C.Loaded;
begin
  inherited;
  //  
  //   -
  if not (csDesigning in ComponentState) then begin
    //     
    if AutoConnect then begin
      DoConnect;
    end;
  end;
end;

//      
procedure TConfiguration1C.SendConnectEvent;
var
  I: Integer;
begin
  //     
  for I := 0 to FClients.Count - 1 do begin
    if TObject(FClients[I]) is TComponent1C then
      TComponent1C(FClients[I]).ConnectEvent;
  end;
end;

// (<>)
function TConfiguration1C.CreateObject(AObjectTypeName: String): Variant;
begin
  Result := Server.CreateObject(OleVariant(AObjectTypeName));
end;

function TConfiguration1C.GetEvalExprValue(const AExpression: String): Variant;
begin
  Result := Server.EvalExpr(OleVariant(AExpression));
end;

// ExecuteBatch(<>)
function TConfiguration1C.ExecuteBatch(AOperatorsStr: String): Boolean;
begin
  Result := Boolean(Server.ExecuteBatch(OleVariant(AOperatorsStr))
    = OLE_True);
end;

end.
