unit XBase1C;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  config1C;

type
  TXBase1C = class(TComponent1C)
  private
    FObj: Variant;
    //   1-
    function CreateObj: Variant;
    // get-  set-
    function GetFieldsValue(const AFieldName: String): Variant;
    procedure SetFieldsValue(const AFieldName: String;
      const AValue: Variant);
  protected
    //    - 
    //   /  OLE-
    //      !
    procedure ConnectEvent; override;
  public
    // 
    constructor Create(AOwner: TComponent); override;
    //    1- (IDispatch)
    property Obj: Variant read FObj;
    //  property,    
    //   ,  "XBase.Obj."
    //   "XBase['']"
    property Fields[const FieldName: String]: Variant
      read GetFieldsValue write SetFieldsValue; default;
    //   1-
    // (<>,<>)
    procedure CreateBase(ABasePath, AIndexPath: Variant);
    // (<>,<>,<>)
    procedure OpenBase(ABasePath, AIndexPath: Variant;
      AReadOnly: Boolean = False);
    // ()
    function IsOpen: Boolean;
    // ()
    procedure CloseBase;
    // ()
    procedure Zap;
    // ()
    procedure Pack;
    // ()
    procedure Reindex;
    // (<>)
    function ShowDeleted(ARegime: Variant): Boolean;
    // ()
    function First: Boolean;
    // ()
    function Last: Boolean;
    // ()
    function Next: Boolean;
    // ()
    function Prev: Boolean;
    // ()
    function RecNo: Integer;
    // (<>)
    procedure GoToRec(ARecNo: Integer);
    // ()
    function EOF: Boolean;
    // ()
    function BOF: Boolean;
    // (<>)
    function CurrentIndex(AIndexName: Variant): String;
    // (<>,<>)
    function Find(AKey: String; ARegime: Integer): Boolean;
    // (<>)
    function FindByKey(ARegime: Integer): Boolean;
    // (<>)
    function GetFieldValue(AField: Variant): Variant;
    // (<>,<>)
    procedure SetFieldValue(AField: Variant; AValue: Variant);
    // ()
    procedure Add;
    // ()
    procedure Copy;
    // (<>)
    function AutoSave(ARegime: Variant): Boolean;
    // ()
    procedure Save;
    // ()
    procedure Cancel;
    // ()
    procedure Del;
    // ()
    function RecDeleted: Boolean;
    // ()
    procedure Recall;
    // ()
    procedure Clear;
    // ()
    function RecCount: Integer;
    // ()
    function FieldCount: Integer;
    // ()
    function IndexCount: Integer;
    // (<>)
    function FieldNo(AFieldName: String): Integer;
    // (<>,<>,<>,<>)
    procedure AddField(AFieldName: String; AType, ALength,
      APrecision: Variant);
    // (<>,<>,<>,
    //   <>,<>)
    procedure AddIndex(AIndexName, AIndexValue: String;
      AUnique, ADesc: Boolean; AFilter: String);
    // (<>)
    procedure CreateIndex(AFileName: String);
    // (<>)
    function CodePage(ARegime: Variant): Integer;
    // ()
    function ErrorCode: Integer;
  published
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('1C Servers', [TXBase1C]);
end;

{ TXBase1C }

// ()
procedure TXBase1C.Add;
begin
  FObj.(Unassigned);
end;

// (<>,<>,<>,<>)
procedure TXBase1C.AddField(AFieldName: String; AType, ALength,
  APrecision: Variant);
begin
  FObj.(OleVariant(AFieldName), OleVariant(AType),
    OleVariant(ALength), OleVariant(APrecision));
end;

// (<>,<>,<>,
//   <>,<>)
procedure TXBase1C.AddIndex(AIndexName, AIndexValue: String; AUnique,
  ADesc: Boolean; AFilter: String);
begin
  FObj.(OleVariant(AIndexName), OleVariant(AIndexValue),
    OleVariant(AUnique), OleVariant(ADesc), OleVariant(AFilter));
end;

// (<>)
function TXBase1C.AutoSave(ARegime: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ARegime)));
end;

// ()
function TXBase1C.BOF: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
procedure TXBase1C.Cancel;
begin
  FObj.(Unassigned);
end;

// ()
procedure TXBase1C.Clear;
begin
  FObj.(Unassigned);
end;

// ()
procedure TXBase1C.CloseBase;
begin
  FObj.(Unassigned);
end;

// (<>)
function TXBase1C.CodePage(ARegime: Variant): Integer;
begin
  Result := FObj.(OleVariant(ARegime));
end;

//    - 
//   /  OLE-
//      !
procedure TXBase1C.ConnectEvent;
begin
  //     
  if Assigned(Configuration) and Configuration.Connected then begin
    // ...    ,   
    if VarIsEmpty(FObj) then
      FObj := CreateObj;
  end else begin
    //  - 
    FObj := Unassigned;
  end;
end;

// ()
procedure TXBase1C.Copy;
begin
  FObj.(Unassigned);
end;

// 
constructor TXBase1C.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  //  properties
  FObj := Unassigned;
end;

// (<>,<>)
procedure TXBase1C.CreateBase(ABasePath, AIndexPath: Variant);
begin
  FObj.(OleVariant(ABasePath), OleVariant(AIndexPath));
end;

// (<>)
procedure TXBase1C.CreateIndex(AFileName: String);
begin
  FObj.(OleVariant(AFileName));
end;

//   1-
function TXBase1C.CreateObj: Variant;
begin
  try
    Result := Configuration.CreateObject('XBase');
  except
    MessageDlg('    "XBase"!',
      mtError, [mbOK], 0);
  end;
end;

// (<>)
function TXBase1C.CurrentIndex(AIndexName: Variant): String;
begin
  Result := FObj.(OleVariant(AIndexName));
end;

// ()
procedure TXBase1C.Del;
begin
  FObj.(Unassigned);
end;

// ()
function TXBase1C.EOF: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
function TXBase1C.ErrorCode: Integer;
begin
  Result := FObj.(Unassigned);
end;

// ()
function TXBase1C.FieldCount: Integer;
begin
  Result := FObj.(Unassigned);
end;

// (<>)
function TXBase1C.FieldNo(AFieldName: String): Integer;
begin
  Result := FObj.(OleVariant(AFieldName));
end;

// (<>,<>)
function TXBase1C.Find(AKey: String; ARegime: Integer): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(AKey), OleVariant(ARegime)));
end;

// (<>)
function TXBase1C.FindByKey(ARegime: Integer): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ARegime)));
end;

// ()
function TXBase1C.First: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

function TXBase1C.GetFieldsValue(
  const AFieldName: String): Variant;
begin
  Result := FObj.(OleVariant(AFieldName));
end;

// (<>)
function TXBase1C.GetFieldValue(AField: Variant): Variant;
begin
  Result := FObj.(OleVariant(AField));
end;

// (<>)
procedure TXBase1C.GoToRec(ARecNo: Integer);
begin
  FObj.(OleVariant(ARecNo));
end;

// ()
function TXBase1C.IndexCount: Integer;
begin
  Result := FObj.(Unassigned);
end;

// ()
function TXBase1C.IsOpen: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
function TXBase1C.Last: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
function TXBase1C.Next: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// (<>,<>,<>)
procedure TXBase1C.OpenBase(ABasePath, AIndexPath: Variant;
  AReadOnly: Boolean);
begin
  FObj.(OleVariant(ABasePath), OleVariant(AIndexPath),
    OleVariant(AReadOnly));
end;

// ()
procedure TXBase1C.Pack;
begin
  FObj.(Unassigned);
end;

// ()
function TXBase1C.Prev: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
procedure TXBase1C.Recall;
begin
  FObj.(Unassigned);
end;

// ()
function TXBase1C.RecCount: Integer;
begin
  Result := FObj.(Unassigned);
end;

// ()
function TXBase1C.RecDeleted: Boolean;
begin
  Result := Boolean(FObj.(Unassigned));
end;

// ()
function TXBase1C.RecNo: Integer;
begin
  Result := FObj.(Unassigned);
end;

// ()
procedure TXBase1C.Reindex;
begin
  FObj.(Unassigned);
end;

// ()
procedure TXBase1C.Save;
begin
  FObj.(Unassigned);
end;

procedure TXBase1C.SetFieldsValue(const AFieldName: String;
  const AValue: Variant);
begin
  FObj.(OleVariant(AFieldName),
    OleVariant(AValue));
end;

// (<>,<>)
procedure TXBase1C.SetFieldValue(AField, AValue: Variant);
begin
  FObj.(OleVariant(AField), OleVariant(AValue));
end;

// (<>)
function TXBase1C.ShowDeleted(ARegime: Variant): Boolean;
begin
  Result := Boolean(FObj.(OleVariant(ARegime)));
end;

// ()
procedure TXBase1C.Zap;
begin
  FObj.(Unassigned);
end;

end.
