#ifndef STATUS_STRUCT
#define STATUS_STRUCT
typedef struct{
  unsigned long	d_counter;//actual counter of ok-prints
  unsigned long	s_counter;//actual counter of nok-prints
  unsigned long	n_messageport;//actual external message selection
  unsigned char	Start;//0: system is printing 1: system is stopped
  unsigned char	request;//(internal variable)
  unsigned char	option;//(internal variable)
  unsigned char	res;//reserved (0x0:default, 0x1: UMT enabled, 0x4: Batchjob enabled)
  unsigned long	t_counter;//total counter of prints
  unsigned long	m_copies;//actual nr of copies to be printed
  unsigned long err;//alarmcode (upper WORD: codifies lastactive alarm; lower WORD: 0: noalarm, else: alarm active)
  unsigned long time;//reserved D-Word (actually used as timeofprint-info)
  char  name[8];//actual active filename (max.8 chars)
  unsigned long reserved1;	//reserved
  unsigned long reserved2;	//reserved
} PStatus;
#endif

#ifndef SOCKETCOMMDLLEXPORT_H
#define SOCKETCOMMDLLEXPORT_H

#define COPY_TO_RAMDISK  0
#define COPY_TO_HARDDISK 1
#define COPY_FROM_HARDDISK 2
#define COPY_FROM_RAMDISK 4

#define COPY_TECHNICIAN 128

extern "C" {
	//////////////////////////////////////////////////////////
	//							//
	//General functions to initialize or close a connection	//
	//							//
	//////////////////////////////////////////////////////////
__declspec(dllexport) void __stdcall MInit(long* p, char *name, char *ip, char *path); //Initialize socket
__declspec(dllexport) void __stdcall MFinish(long p); //Close socket
__declspec(dllexport) int __stdcall MStartClient(long p); //Establishes connection to the system
__declspec(dllexport) int __stdcall MLaser_Knockout(long p); //should be called before Shutdown client
			//to indicate the laser that the connection will be going down
__declspec(dllexport) int __stdcall MShutdownClient(long p); //Close connection to the system
__declspec(dllexport) int __stdcall MGetLastError(long p, char &txt); //returns pointer to internal char-array; size: 256
__declspec(dllexport) int __stdcall MIsConnected(long p); 
			//returns 0 if system is not connected
			//returns 1 if system is connnected
__declspec(dllexport) int __stdcall MSetTimeout(long p, int timeout);

	//////////////////////////////////////////////////////////////////
	//								//
	//Laser control functions (can be used after initialization)	//	
	//								//
	//////////////////////////////////////////////////////////////////

__declspec(dllexport) int __stdcall MLaser_Stop(long p, long timeout); //Stop signal
			//timeout: in milliseconds, time to wait for answer

__declspec(dllexport) int __stdcall MLaser_Usermessage(long p, unsigned char field, const char *text);
			//send string "text" (max. 127 chars) for <field> to the laser
__declspec(dllexport) int __stdcall MLaser_FastUsermessage(long p, unsigned char field, const char *text);
			//send string "text" (max. 127 chars) for <field> to the laser

__declspec(dllexport) int __stdcall MLaser_Status(long p, PStatus &status); //gets status of lasersystem
			//fills  status variable with actual status

__declspec(dllexport) unsigned short __stdcall MGetVersion(long p); //sets connection timeout variable
			//value in milliseconds
__declspec(dllexport) int __stdcall MLaser_Start(long p, const char *filename,int nr); //Start signal
			//filename: name of the message inside the laser to be printed (without extension)
			//nr:  number of prints to be done (nr=0 eternal printing, nr=1 testprint)
__declspec(dllexport) int __stdcall MLaser_Reload(long p); //reloads actual printing file
			//used e.g after having sent new data to the laser to reload the actual message
__declspec(dllexport) int __stdcall MLaser_Settime(long p); //Sets actual system time in remote lasersystem
			//uses the OS system time as a reference time
__declspec(dllexport) int __stdcall MLaser_Delete(long p, const char *name); //deletes file
			//name: filename with extension inside the laser
__declspec(dllexport) int __stdcall MLaser_SetDefault(long p, const char *name); //sets actual file
			//changes actual message inside the laser to <name> (without extension)
__declspec(dllexport) int __stdcall MLaser_CopyFile(long p, const char * filename, const char * path, unsigned char option);
			//sourcefile: local filename to be sent to the laser (msf-file)
			//path: directory ending with "\\" of location of the file 
			//option: copy to ramdisk or to harddisk
__declspec(dllexport) int __stdcall MLaser_Mode(long p, unsigned char &mode); //sets mode (static/dynamic)
			//mode: 0  static, 1: dynamic standard 2: dynamic distance
			// 3: dynamic-static
			// 8: fills <mode> variable with actual mode

__declspec(dllexport) int __stdcall MLaser_CounterReset(long p); //Reset of d_counter and s_counter (status variable)

__declspec(dllexport) int __stdcall MLaser_SetGlobalCounter(long p, unsigned char field, const char* counter); 
//Set global counter
__declspec(dllexport) int __stdcall MLaser_GetGlobalCounter(long p, unsigned char field, char &counter); 
//Get global counter
__declspec(dllexport) int __stdcall MLaser_Offset(long p, long &dx, long &dy, long relative,long format=0,long reset=0); 
//set offset  (format: 0 (ideal coordinates; 1: microns; 2: 0.1mm)

}
#endif